<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="netui-tags-html.tld" prefix="netui-compat"%>
<%@ taglib uri="netui-tags-template.tld" prefix="netui-compat-template"%>
<%@ taglib uri="netui-tags-databinding.tld" prefix="netui-compat-data"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.summaryHelpURI}" />
<c:set var="printerFriendlyPageAction" value="viewPrinterFriendlyIndex" />
<c:set var="showUpdatingMsg" value="true" />
<%@ include file="pageHeader.jspf" %>

<h2><netui:content value="${pageFlow.extractName}"/> Summary</h2>

<netui-compat-template:visible visibility="{pageFlow.populated}">
<%@ include file="indexDescription.jspf" %>
</netui-compat-template:visible>

<% 
//ccr# 3919: set the url for next page to Return to Summary
String path = request.getContextPath()+"/mhv.portal";
if (request.getQueryString() != null) {
   path += '?' + request.getQueryString();
}

String url = new java.net.URL(request.getScheme(),
                               request.getServerName(),
                               request.getServerPort(),
                               path).toString();

session.setAttribute("chemlabs.returnToSummaryURL", url); 
%>
<p>
	<display:table id="${pageFlow.tableUID}" 
	    uid="${pageFlow.tableUID}" 
		name="${pageFlow.testLabTableDecorators}"
	    pagesize="10" 
	    sort="list"  
	    defaultsort="${pageFlow.defaultSortProperty}" 
	    defaultorder="${pageFlow.defaultSortOrder.name}"
	    requestURI="handlePagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.sortClassName}" />
	    <display:setProperty name="paging.banner.item_name" 
	    	value="test record" />
	    <display:setProperty name="paging.banner.items_name" 
	    	value="test records" />
    	<display:setProperty name="basic.msg.empty_list_row"
	    	value="No test records were found" />
	    	

   	    <display:column title=" " sortable="false" 
   	    		sortProperty="collectedOn" style="padding: 3px 3px 4px 3px">
   	    	<c:choose>
		        	<c:when test="${ChemLabs.amended}">
	        		Amended
				</c:when>
				<c:otherwise>
				&nbsp;
				</c:otherwise>
			</c:choose>
        </display:column>
		<display:column property="collectedOn" sortable="true" 
			sortProperty="collectedOnDate"  title="Date/Time Collected" 
			href="viewDetails.do" paramId="id" paramProperty="id" />
		<display:column property="specimen" sortable="true" sortName="specimen" title="Specimen"/>
		<display:column property="orderingLocation" sortable="true" 
		    title="Location"/>
	</display:table>
</p>

<%@ include file="goldStandardText.jspf"%>

<%@ include file="../../common/pageFooter.jspf" %>